#!/usr/bin/perl -w

# add dtoverlay=w1-gpio to /boot/config.txt

# create file /etc/modprobe.d/1-wire.conf with this contents
# options w1-gpio pullup=1
# options w1-therm strong_pullup=1

use strict;
use DBI;

my ($db_user, $db_name, $db_pass, $db_host) = ('db-user', 'db-name', "db-pass", "db-ip");
my $dbh = DBI->connect("DBI:mysql:database=$db_name;host=$db_host", $db_user, $db_pass);


my $wp_vorlauf = "";
my $wp_ruecklauf = "";
my $fbh_vorlauf = "";
my $fbh_ruecklauf = "";

$fbh_vorlauf = &readTemp("/sys/bus/w1/devices/28-0000052927e9/w1_slave") ;
$fbh_ruecklauf = &readTemp("/sys/bus/w1/devices/28-000005298dcf/w1_slave") ;


# Neue Daten einfuegen
my $query = $dbh->prepare("INSERT INTO temperaturen SET datum = NOW(), `wp-vorlauf` = '$wp_vorlauf', `wp-ruecklauf` = '$wp_ruecklauf', `fbh-vorlauf` = '$fbh_vorlauf', `fbh-ruecklauf` = '$fbh_ruecklauf' ");
$query->execute() or die $query->err_str;

# Alte Datensaetze loeschen
$query = $dbh->prepare("DELETE FROM temperaturen WHERE DATE_SUB(now(), INTERVAL 60 DAY) >= datum");
$query->execute() or die $query->err_str;

# DB schliessen
$dbh->disconnect();

exit;



sub readTemp() {
        my $erg;
        do {

                my ($path) = @_;
                open(FILE, "<$path") || die "Datei '$path' nicht gefunden\n";
                my $dummy = "";
                while(<FILE>) {
                          $dummy = $_;
                 }
                close(FILE);

                my @array=split(/t=/,$dummy);
                $erg = $array[1] / 1000;
        } until (($erg <= 70) && ($erg >= 0)) ;

        return ($erg);
}
